﻿using System;
using System.Runtime.Remoting.Channels;

namespace gov.va.med.VBECS.Communication.Channels
{
    /// <summary>
    /// Stores communication channel information to be used by an event.
    /// </summary>
    public class ChannelEventArgs : EventArgs
    {
        /// <summary>
        /// Communication channel that is associated with this event.
        /// </summary>
        public IChannel Channel { get; private set; }

        /// <summary>
        /// Creates a new CommunicationChannelEventArgs object.
        /// </summary>
        /// <param name="theChannel">Communication channel that is associated with this event</param>
        public ChannelEventArgs(IChannel theChannel)
        {
            this.Channel = theChannel;
        }
    }
}
